/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import com.lothrazar.cyclic.item.builder.BuildStyle;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilPlayer;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketSwapBlock
extends PacketBaseCyclic {
    private BlockPos pos;
    private BuilderActionType actionType;
    private Direction side;
    private InteractionHand hand;

    public PacketSwapBlock(BlockPos readBlockPos, BuilderActionType type, Direction dir, InteractionHand h) {
        this.pos = readBlockPos;
        this.actionType = type;
        this.side = dir;
        this.hand = h;
    }

    public static PacketSwapBlock decode(FriendlyByteBuf buf) {
        return new PacketSwapBlock(buf.m_130135_(), BuilderActionType.values()[buf.readInt()], Direction.values()[buf.readInt()], InteractionHand.values()[buf.readInt()]);
    }

    public static void encode(PacketSwapBlock msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.actionType.ordinal());
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketSwapBlock message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack itemStackHeld = player.m_21120_(message.hand);
            BlockState targetState = BuilderActionType.getBlockState(itemStackHeld);
            if (targetState == null || !(itemStackHeld.m_41720_() instanceof BuilderItem)) {
                return;
            }
            BuildStyle buildStyle = ((BuilderItem)itemStackHeld.m_41720_()).style;
            Level world = player.m_20193_();
            List<BlockPos> places = PacketSwapBlock.getSelectedBlocks(world, message.pos, message.actionType, message.side, buildStyle);
            HashMap<BlockPos, Integer> processed = new HashMap<BlockPos, Integer>();
            boolean atLeastOne = false;
            List<BlockPos> list = places;
            synchronized (list) {
                for (BlockPos curPos : places) {
                    if (!processed.containsKey(curPos)) {
                        processed.put(curPos, 0);
                    }
                    if ((Integer)processed.get(curPos) > 0) continue;
                    processed.put(curPos, (Integer)processed.get(curPos) + 1);
                    int slot = UtilPlayer.getFirstSlotWithBlock((Player)player, targetState);
                    if (slot < 0 && !player.m_7500_()) {
                        UtilChat.sendStatusMessage((Player)player, "scepter.cyclic.empty");
                        break;
                    }
                    if (world.m_7702_(curPos) != null) continue;
                    BlockState replacedBlockState = world.m_8055_(curPos);
                    Block replacedBlock = replacedBlockState.m_60734_();
                    boolean isInBlacklist = false;
                    if (isInBlacklist || replacedBlockState.m_60800_((BlockGetter)world, curPos) < 0.0f || UtilWorld.doBlockStatesMatch(replacedBlockState, targetState)) continue;
                    world.m_7731_(curPos, Blocks.f_50016_.m_49966_(), 0);
                    boolean success = false;
                    if (!success) {
                        success = UtilPlaceBlocks.placeStateSafe(world, (Player)player, curPos, targetState);
                    }
                    if (!success) continue;
                    atLeastOne = true;
                    UtilPlayer.decrStackSize((Player)player, slot);
                    world.m_46796_(2001, curPos, Block.m_49956_((BlockState)targetState));
                    replacedBlock.m_6240_(world, (Player)player, curPos, replacedBlockState, null, itemStackHeld);
                }
            }
            if (atLeastOne) {
                UtilItemStack.damageItem((LivingEntity)player, itemStackHeld);
            }
        });
        message.done(ctx);
    }

    public static List<BlockPos> getSelectedBlocks(Level world, BlockPos pos, BuilderActionType actionType, Direction side, BuildStyle style) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.m_123341_();
        int yMin = pos.m_123342_();
        int zMin = pos.m_123343_();
        int xMax = pos.m_123341_();
        int yMax = pos.m_123342_();
        int zMax = pos.m_123343_();
        boolean isVertical = side == Direction.UP || side == Direction.DOWN;
        int offsetH = 0;
        int offsetW = 0;
        switch (actionType) {
            case SINGLE: {
                places.add(pos);
                offsetH = 0;
                offsetW = 0;
                break;
            }
            case X3: {
                offsetH = 1;
                offsetW = 1;
                break;
            }
            case X5: {
                offsetH = 2;
                offsetW = 2;
                break;
            }
            case X7: {
                offsetH = 3;
                offsetW = 3;
                break;
            }
            case X9: {
                offsetH = 4;
                offsetW = 4;
                break;
            }
            case X19: {
                offsetH = 0;
                offsetW = 4;
                break;
            }
            case X91: {
                offsetH = 4;
                offsetW = 0;
                break;
            }
        }
        if (actionType != BuilderActionType.SINGLE) {
            if (isVertical) {
                xMin -= offsetH;
                xMax += offsetH;
                zMin -= offsetW;
                zMax += offsetW;
            } else if (side == Direction.EAST || side == Direction.WEST) {
                zMin -= offsetH;
                zMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            } else {
                xMin -= offsetH;
                xMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        ArrayList<BlockPos> retPlaces = new ArrayList<BlockPos>();
        for (BlockPos p : places) {
            if (!world.m_8055_(p).m_60767_().m_76336_() && !style.isReplaceable()) continue;
            retPlaces.add(p);
        }
        return retPlaces;
    }
}

